#include <String.h>
#include <Servo.h>
#include <LiquidCrystal.h>
#include <Sensirion.h>
String command;

LiquidCrystal lcd(12, 14, 13, 8, 11, 9, 10);
Servo ServoA;
int flow;
float temperature, humidity, dewpoint;
int waterON;    // 1 water is ON, 0 water is OFF
int IsAuto;     // 0 automat neni zapnuty, 1 integralni automat
int zadana;     // zadana hodnota RH udrzovana automatem

int kp = 10;
int ti = 0.4;
int td = 0.4;
int ki = 1;
int kd = 1;
double sum = 0;
double old_odchylka = 0;

const uint8_t dataPin  =  2;
const uint8_t clockPin =  4;
Sensirion tempSensor = Sensirion(dataPin, clockPin);

void setup() 
{                
  // initialize the digital pin as an output.
  // Pin 13 has an LED connected on most Arduino boards:
  pinMode(3, OUTPUT); 
  pinMode(7, OUTPUT);  
  
  ServoA.attach(6);
 
  lcd.begin(20, 4);
  Serial.begin(9600); 
  
  command = "I am waiting... ";
  IsAuto = 0;      // automat vypnut na zacatku
  zadana = 40;     // defaultni hodnota vlhkosti udrzovana automatem
  setAir();
  setFlow(0);
}

void print_to_lcd()
{
  lcd.setCursor(0, 0);
  lcd.print("I:                  "); 
  lcd.setCursor(2, 0);
  lcd.print(command);
  
  lcd.setCursor(0, 1);
  lcd.print("Hum: ");
  lcd.print(humidity);
  lcd.print(" %");
  
  lcd.setCursor(0, 2);
  lcd.print("Temp: ");
  lcd.print(temperature);
  lcd.print(" C");
  
  lcd.setCursor(0, 3);
  lcd.print("Run-time:"); 
  lcd.print(millis()/1000);
  lcd.print(" s");
}

void setWater()
{
  digitalWrite(3, HIGH);
  digitalWrite(7, LOW);
  waterON = 1;
}

void setAir()
{
  digitalWrite(3, LOW);
  digitalWrite(7, HIGH);
  waterON = 0;
}

void setFlow(int flow)
{
  ServoA.write(180-flow);
}

void process()
{  
  if  (command.startsWith("Valves"))
  {
    if (command.substring(7).startsWith("Air"))
    {
      setAir();
      command = "Valves:Air";
    }
    if (command.substring(7).startsWith("Water"))
    {
      setWater();
      command = "Valves:Water";
    }    
  }
  if  (command.startsWith("ServoA"))
  {
    String s = command.substring(14);
    flow = stringToNumber(s);
    setFlow(flow);
    command = "ServoA:moveTo_";
    command += flow;
  }
  if (command.startsWith("AutoON"))
  {
     IsAuto = 1;
     String s = command.substring(7);
     zadana = stringToNumber(s);  
     sum = 0;
     old_odchylka = 0;  
     command = "AutoON:";
     command += zadana;  
  }
  if (command.startsWith("AutoOff"))
  {
     IsAuto = 0;
     zadana = 50;  
     sum = 0;
     command = "AutoOff "; 
  } 
  if (command.startsWith("ConstantKp"))
  {
     String s = command.substring(11);
     kp = stringToNumber(s);  
     command = "Kp = ";
     command += kp;
  } 
  if (command.startsWith("ConstantKi"))
  {
     String s = command.substring(11);
     ki = stringToNumber(s);
     command = "Ki = ";
     command += ki;
  } 
  if (command.startsWith("ConstantKd"))
  {
     String s = command.substring(11);
     kd = stringToNumber(s);
     command = "Kd = ";
     command += kd;
  }
}

int stringToNumber(String thisString) {
  int i, value = 0, length;
  length = thisString.length();
  for(i=0; i<length; i++) {
    value = (10*value) + thisString.charAt(i)-(int) '0';
  }
  return value;
}

void readDataFromSensor()
{
  tempSensor.measure(&temperature, &humidity, &dewpoint);
}

int i;
int c;

char ch;
int work = 0;
int lastSend = 0;


void loop()
{
  
  if (Serial.available())
  {
    command = "";
  }
  
  // http://arduino.cc/en/Tutorial/LiquidCrystalSerial
  if (Serial.available()) 
  {
     // wait a bit for the entire message to arrive
     delay(100);
     // read all the available characters
     while (Serial.available() > 0) 
     {
       // save each character to the temp variable
       ch = (char) Serial.read();
       
       if (ch == 13)
       {
         command = "";
         work = 0;
         continue;
       }
       
       if (ch == 10)
       {
         if (work == 1) process();
         work = 0;
         continue;
       }
       
       work = 1;
       command += ch;
     }
  }
  
  
  
  //
  //SAMOCINNY PID REGULATOR
  //
  
  
  int regulacni_zasah;
  int t0 = 2;
  double old_odchylka = 0;
  double oldold_odchylka = 0;
  int old_regulacni_zasah = 0;
  
  if (IsAuto == 1)
  {
      //nacteni dat ze senzoru
      readDataFromSensor();
      
      // vypocet hodnoty pro servo
      double odchylka = humidity - zadana;  // odchylka > 0 dodej N2, odchylka < 0 dodej H2O
      
      //nastaveni konstanty dle intervalu zadane hodnoty
      if ((zadana < 25) || (zadana > 55)) kp=10;
      else if ((zadana >= 35) && (zadana <= 45)) kp=4;
      else kp = 6;
      
      // minimalni tolerovatelna odchylka
      if ((odchylka < 0.2) && (odchylka > -0.2))
          odchylka = 0;
      
      //vypocet zasahu
      regulacni_zasah = kp*(odchylka - old_odchylka + odchylka * t0 / ki + (odchylka - 2 * old_odchylka + oldold_odchylka) * kd / t0) + old_regulacni_zasah;
        
      //aktualizace pro dalsi krok regulace
      oldold_odchylka = old_odchylka;
      old_odchylka = odchylka;
            
      //omezeni hodnoty akcniho zasahu pro dalsi krok
      if (regulacni_zasah < -200) regulacni_zasah = -200;
      else if (regulacni_zasah > 200) regulacni_zasah = 200;      
      
      //aktualizace pro dalsi krok
      old_regulacni_zasah = regulacni_zasah;
           
      // omezeni hodnoty pro servo
      if (regulacni_zasah < -180) regulacni_zasah = -180;
      else if (regulacni_zasah > 180) regulacni_zasah = 180;
          
      // nastav ventil water/air a posli hodnotu do serva    
      if (regulacni_zasah < 0) 
      {
         if (waterON == 0) setWater();
         flow = -regulacni_zasah;
         setFlow(flow);        
      }
      else
      {
         if (waterON == 1) setAir();
         flow = regulacni_zasah;
         setFlow(flow);
      }
      
   }

  
  
  
  
  
     // Lukas omezeni 
     if (millis()/1000 > lastSend+1 )
     {
       readDataFromSensor();
       Serial.print("hum");
       Serial.print(humidity);
       Serial.print("tem");
       Serial.print(temperature);
       Serial.print("sec");
       Serial.print(millis()/1000);
       Serial.print("wat");
       Serial.print(waterON);
       Serial.print("flo");
       Serial.println(flow);
      
       lastSend = millis()/1000;
       
       /*
       if ((lastSend > 30) && (lastSend < 60))
       {
         zadana = 60;
       }
       else if (lastSend >= 60)
       {
         zadana = 40;
       }
       */
     }     
   
  readDataFromSensor();
  print_to_lcd();     
  delay(300); 
}

